/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSEntity.h"

#include <wtf/GetPtr.h>

#include "Entity.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSEntityTableValues[5] =
{
    { "publicId", (intptr_t)JSEntity::PublicIdAttrNum, DontDelete|ReadOnly, 0 },
    { "systemId", (intptr_t)JSEntity::SystemIdAttrNum, DontDelete|ReadOnly, 0 },
    { "notationName", (intptr_t)JSEntity::NotationNameAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSEntity::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSEntityTable = { 15, JSEntityTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSEntityConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSEntityConstructorTable = { 0, JSEntityConstructorTableValues, 0 };

class JSEntityConstructor : public DOMObject {
public:
    JSEntityConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSEntityPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSEntityConstructor::s_info = { "EntityConstructor", 0, &JSEntityConstructorTable, 0 };

bool JSEntityConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEntityConstructor, DOMObject>(exec, &JSEntityConstructorTable, this, propertyName, slot);
}

JSValue* JSEntityConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSEntityPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSEntityPrototypeTable = { 0, JSEntityPrototypeTableValues, 0 };

const ClassInfo JSEntityPrototype::s_info = { "EntityPrototype", 0, &JSEntityPrototypeTable, 0 };

JSObject* JSEntityPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSEntity.prototype]]");
    return KJS::cacheGlobalObject<JSEntityPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSEntity::s_info = { "Entity", &JSNode::s_info, &JSEntityTable , 0 };

JSEntity::JSEntity(JSObject* prototype, Entity* impl)
    : JSNode(prototype, impl)
{
}

bool JSEntity::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEntity, Base>(exec, &JSEntityTable, this, propertyName, slot);
}

JSValue* JSEntity::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case PublicIdAttrNum: {
        Entity* imp = static_cast<Entity*>(impl());
        return jsStringOrNull(exec, imp->publicId());
    }
    case SystemIdAttrNum: {
        Entity* imp = static_cast<Entity*>(impl());
        return jsStringOrNull(exec, imp->systemId());
    }
    case NotationNameAttrNum: {
        Entity* imp = static_cast<Entity*>(impl());
        return jsStringOrNull(exec, imp->notationName());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSEntity::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[Entity.constructor]]");
    return KJS::cacheGlobalObject<JSEntityConstructor>(exec, constructorIdentifier);
}


}
