/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSElement_h
#define JSElement_h

#include "JSEventTargetNode.h"
#include <kjs/lookup.h>
#include <wtf/AlwaysInline.h>
#include "Element.h"
namespace WebCore {

class Element;

class JSElement : public JSEventTargetNode {
    typedef JSEventTargetNode Base;
public:
    JSElement(KJS::JSObject* prototype, Element*);
    virtual bool getOwnPropertySlot(KJS::ExecState*, const KJS::Identifier& propertyName, KJS::PropertySlot&);
    KJS::JSValue* getValueProperty(KJS::ExecState*, int token) const;
    virtual void put(KJS::ExecState*, const KJS::Identifier& propertyName, KJS::JSValue*);
    void putValueProperty(KJS::ExecState*, int, KJS::JSValue*);
    virtual const KJS::ClassInfo* classInfo() const { return &s_info; }
    static const KJS::ClassInfo s_info;

    static KJS::JSValue* getConstructor(KJS::ExecState*);
    enum {
        // Attributes
        TagNameAttrNum, StyleAttrNum, OffsetLeftAttrNum, OffsetTopAttrNum, 
        OffsetWidthAttrNum, OffsetHeightAttrNum, OffsetParentAttrNum, ClientLeftAttrNum, 
        ClientTopAttrNum, ClientWidthAttrNum, ClientHeightAttrNum, ScrollLeftAttrNum, 
        ScrollTopAttrNum, ScrollWidthAttrNum, ScrollHeightAttrNum, FirstElementChildAttrNum, 
        LastElementChildAttrNum, PreviousElementSiblingAttrNum, NextElementSiblingAttrNum, ChildElementCountAttrNum, 

        // The Constructor Attribute
        ConstructorAttrNum
    };

    // Custom functions
    KJS::JSValue* setAttribute(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* setAttributeNode(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* setAttributeNS(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* setAttributeNodeNS(KJS::ExecState*, const KJS::ArgList&);
    Element* impl() const
    {
        return static_cast<Element*>(Base::impl());
    }
};

ALWAYS_INLINE bool JSElement::getOwnPropertySlot(KJS::ExecState* exec, const KJS::Identifier& propertyName, KJS::PropertySlot& slot)
{
    return KJS::getStaticValueSlot<JSElement, Base>(exec, s_info.staticPropHashTable, this, propertyName, slot);
}

Element* toElement(KJS::JSValue*);
KJS::JSValue* toJSNewlyCreated(KJS::ExecState*, Element*);

class JSElementPrototype : public KJS::JSObject {
public:
    static KJS::JSObject* self(KJS::ExecState*);
    virtual const KJS::ClassInfo* classInfo() const { return &s_info; }
    static const KJS::ClassInfo s_info;
    bool getOwnPropertySlot(KJS::ExecState*, const KJS::Identifier&, KJS::PropertySlot&);
    JSElementPrototype(KJS::ExecState* exec)
        : KJS::JSObject(JSEventTargetNodePrototype::self(exec)) { }
};

// Functions

KJS::JSValue* jsElementPrototypeFunctionGetAttribute(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionSetAttribute(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionRemoveAttribute(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionGetAttributeNode(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionSetAttributeNode(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionRemoveAttributeNode(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionGetElementsByTagName(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionGetAttributeNS(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionSetAttributeNS(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionRemoveAttributeNS(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionGetElementsByTagNameNS(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionGetAttributeNodeNS(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionSetAttributeNodeNS(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionHasAttribute(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionHasAttributeNS(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionFocus(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionBlur(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionScrollIntoView(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionContains(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionScrollIntoViewIfNeeded(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionScrollByLines(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionScrollByPages(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionGetElementsByClassName(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionQuerySelector(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsElementPrototypeFunctionQuerySelectorAll(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
} // namespace WebCore

#endif
