/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSDOMCoreException.h"

#include <wtf/GetPtr.h>

#include "DOMCoreException.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDOMCoreExceptionTableValues[5] =
{
    { "code", (intptr_t)JSDOMCoreException::CodeAttrNum, DontDelete|ReadOnly, 0 },
    { "name", (intptr_t)JSDOMCoreException::NameAttrNum, DontDelete|ReadOnly, 0 },
    { "message", (intptr_t)JSDOMCoreException::MessageAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSDOMCoreException::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSDOMCoreExceptionTable = { 127, JSDOMCoreExceptionTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSDOMCoreExceptionConstructorTableValues[18] =
{
    { "INDEX_SIZE_ERR", (intptr_t)1, DontDelete|ReadOnly, 0 },
    { "DOMSTRING_SIZE_ERR", (intptr_t)2, DontDelete|ReadOnly, 0 },
    { "HIERARCHY_REQUEST_ERR", (intptr_t)3, DontDelete|ReadOnly, 0 },
    { "WRONG_DOCUMENT_ERR", (intptr_t)4, DontDelete|ReadOnly, 0 },
    { "INVALID_CHARACTER_ERR", (intptr_t)5, DontDelete|ReadOnly, 0 },
    { "NO_DATA_ALLOWED_ERR", (intptr_t)6, DontDelete|ReadOnly, 0 },
    { "NO_MODIFICATION_ALLOWED_ERR", (intptr_t)7, DontDelete|ReadOnly, 0 },
    { "NOT_FOUND_ERR", (intptr_t)8, DontDelete|ReadOnly, 0 },
    { "NOT_SUPPORTED_ERR", (intptr_t)9, DontDelete|ReadOnly, 0 },
    { "INUSE_ATTRIBUTE_ERR", (intptr_t)10, DontDelete|ReadOnly, 0 },
    { "INVALID_STATE_ERR", (intptr_t)11, DontDelete|ReadOnly, 0 },
    { "SYNTAX_ERR", (intptr_t)12, DontDelete|ReadOnly, 0 },
    { "INVALID_MODIFICATION_ERR", (intptr_t)13, DontDelete|ReadOnly, 0 },
    { "NAMESPACE_ERR", (intptr_t)14, DontDelete|ReadOnly, 0 },
    { "INVALID_ACCESS_ERR", (intptr_t)15, DontDelete|ReadOnly, 0 },
    { "VALIDATION_ERR", (intptr_t)16, DontDelete|ReadOnly, 0 },
    { "TYPE_MISMATCH_ERR", (intptr_t)17, DontDelete|ReadOnly, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSDOMCoreExceptionConstructorTable = { 511, JSDOMCoreExceptionConstructorTableValues, 0 };

class JSDOMCoreExceptionConstructor : public DOMObject {
public:
    JSDOMCoreExceptionConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSDOMCoreExceptionPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSDOMCoreExceptionConstructor::s_info = { "DOMExceptionConstructor", 0, &JSDOMCoreExceptionConstructorTable, 0 };

bool JSDOMCoreExceptionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMCoreExceptionConstructor, DOMObject>(exec, &JSDOMCoreExceptionConstructorTable, this, propertyName, slot);
}

JSValue* JSDOMCoreExceptionConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSDOMCoreExceptionPrototypeTableValues[19] =
{
    { "INDEX_SIZE_ERR", (intptr_t)1, DontDelete|ReadOnly, 0 },
    { "DOMSTRING_SIZE_ERR", (intptr_t)2, DontDelete|ReadOnly, 0 },
    { "HIERARCHY_REQUEST_ERR", (intptr_t)3, DontDelete|ReadOnly, 0 },
    { "WRONG_DOCUMENT_ERR", (intptr_t)4, DontDelete|ReadOnly, 0 },
    { "INVALID_CHARACTER_ERR", (intptr_t)5, DontDelete|ReadOnly, 0 },
    { "NO_DATA_ALLOWED_ERR", (intptr_t)6, DontDelete|ReadOnly, 0 },
    { "NO_MODIFICATION_ALLOWED_ERR", (intptr_t)7, DontDelete|ReadOnly, 0 },
    { "NOT_FOUND_ERR", (intptr_t)8, DontDelete|ReadOnly, 0 },
    { "NOT_SUPPORTED_ERR", (intptr_t)9, DontDelete|ReadOnly, 0 },
    { "INUSE_ATTRIBUTE_ERR", (intptr_t)10, DontDelete|ReadOnly, 0 },
    { "INVALID_STATE_ERR", (intptr_t)11, DontDelete|ReadOnly, 0 },
    { "SYNTAX_ERR", (intptr_t)12, DontDelete|ReadOnly, 0 },
    { "INVALID_MODIFICATION_ERR", (intptr_t)13, DontDelete|ReadOnly, 0 },
    { "NAMESPACE_ERR", (intptr_t)14, DontDelete|ReadOnly, 0 },
    { "INVALID_ACCESS_ERR", (intptr_t)15, DontDelete|ReadOnly, 0 },
    { "VALIDATION_ERR", (intptr_t)16, DontDelete|ReadOnly, 0 },
    { "TYPE_MISMATCH_ERR", (intptr_t)17, DontDelete|ReadOnly, 0 },
    { "toString", (intptr_t)jsDOMCoreExceptionPrototypeFunctionToString, DontDelete|DontEnum|Function, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSDOMCoreExceptionPrototypeTable = { 511, JSDOMCoreExceptionPrototypeTableValues, 0 };

const ClassInfo JSDOMCoreExceptionPrototype::s_info = { "DOMExceptionPrototype", 0, &JSDOMCoreExceptionPrototypeTable, 0 };

JSObject* JSDOMCoreExceptionPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSDOMCoreException.prototype]]");
    return KJS::cacheGlobalObject<JSDOMCoreExceptionPrototype>(exec, prototypeIdentifier);
}

bool JSDOMCoreExceptionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSDOMCoreExceptionPrototype, JSObject>(exec, &JSDOMCoreExceptionPrototypeTable, this, propertyName, slot);
}

JSValue* JSDOMCoreExceptionPrototype::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

const ClassInfo JSDOMCoreException::s_info = { "DOMException", 0, &JSDOMCoreExceptionTable , 0 };

JSDOMCoreException::JSDOMCoreException(JSObject* prototype, DOMCoreException* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSDOMCoreException::~JSDOMCoreException()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSDOMCoreException::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMCoreException, Base>(exec, &JSDOMCoreExceptionTable, this, propertyName, slot);
}

JSValue* JSDOMCoreException::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CodeAttrNum: {
        DOMCoreException* imp = static_cast<DOMCoreException*>(impl());
        return jsNumber(exec, imp->code());
    }
    case NameAttrNum: {
        DOMCoreException* imp = static_cast<DOMCoreException*>(impl());
        return jsString(exec, imp->name());
    }
    case MessageAttrNum: {
        DOMCoreException* imp = static_cast<DOMCoreException*>(impl());
        return jsString(exec, imp->message());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSDOMCoreException::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[DOMCoreException.constructor]]");
    return KJS::cacheGlobalObject<JSDOMCoreExceptionConstructor>(exec, constructorIdentifier);
}

JSValue* jsDOMCoreExceptionPrototypeFunctionToString(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMCoreException::s_info))
        return throwError(exec, TypeError);
    JSDOMCoreException* castedThisObj = static_cast<JSDOMCoreException*>(thisValue);
    DOMCoreException* imp = static_cast<DOMCoreException*>(castedThisObj->impl());


    KJS::JSValue* result = jsString(exec, imp->toString());
    return result;
}

KJS::JSValue* toJS(KJS::ExecState* exec, DOMCoreException* obj)
{
    return cacheDOMObject<DOMCoreException, JSDOMCoreException, JSDOMCoreExceptionPrototype>(exec, obj);
}
DOMCoreException* toDOMCoreException(KJS::JSValue* val)
{
    return val->isObject(&JSDOMCoreException::s_info) ? static_cast<JSDOMCoreException*>(val)->impl() : 0;
}

}
