/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSCounter.h"

#include <wtf/GetPtr.h>

#include "Counter.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCounterTableValues[5] =
{
    { "identifier", (intptr_t)JSCounter::IdentifierAttrNum, DontDelete|ReadOnly, 0 },
    { "listStyle", (intptr_t)JSCounter::ListStyleAttrNum, DontDelete|ReadOnly, 0 },
    { "separator", (intptr_t)JSCounter::SeparatorAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSCounter::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCounterTable = { 63, JSCounterTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSCounterConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSCounterConstructorTable = { 0, JSCounterConstructorTableValues, 0 };

class JSCounterConstructor : public DOMObject {
public:
    JSCounterConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSCounterPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSCounterConstructor::s_info = { "CounterConstructor", 0, &JSCounterConstructorTable, 0 };

bool JSCounterConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCounterConstructor, DOMObject>(exec, &JSCounterConstructorTable, this, propertyName, slot);
}

JSValue* JSCounterConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSCounterPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSCounterPrototypeTable = { 0, JSCounterPrototypeTableValues, 0 };

const ClassInfo JSCounterPrototype::s_info = { "CounterPrototype", 0, &JSCounterPrototypeTable, 0 };

JSObject* JSCounterPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSCounter.prototype]]");
    return KJS::cacheGlobalObject<JSCounterPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSCounter::s_info = { "Counter", 0, &JSCounterTable , 0 };

JSCounter::JSCounter(JSObject* prototype, Counter* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSCounter::~JSCounter()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSCounter::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCounter, Base>(exec, &JSCounterTable, this, propertyName, slot);
}

JSValue* JSCounter::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case IdentifierAttrNum: {
        Counter* imp = static_cast<Counter*>(impl());
        return jsString(exec, imp->identifier());
    }
    case ListStyleAttrNum: {
        Counter* imp = static_cast<Counter*>(impl());
        return jsString(exec, imp->listStyle());
    }
    case SeparatorAttrNum: {
        Counter* imp = static_cast<Counter*>(impl());
        return jsString(exec, imp->separator());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSCounter::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[Counter.constructor]]");
    return KJS::cacheGlobalObject<JSCounterConstructor>(exec, constructorIdentifier);
}

KJS::JSValue* toJS(KJS::ExecState* exec, Counter* obj)
{
    return cacheDOMObject<Counter, JSCounter, JSCounterPrototype>(exec, obj);
}
Counter* toCounter(KJS::JSValue* val)
{
    return val->isObject(&JSCounter::s_info) ? static_cast<JSCounter*>(val)->impl() : 0;
}

}
