/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSConsole_h
#define JSConsole_h

#include "JSDOMBinding.h"
#include <kjs/JSGlobalObject.h>
#include <kjs/ObjectPrototype.h>

namespace WebCore {

class Console;

class JSConsole : public DOMObject {
    typedef DOMObject Base;
public:
    JSConsole(KJS::JSObject* prototype, Console*);
    virtual ~JSConsole();
    virtual const KJS::ClassInfo* classInfo() const { return &s_info; }
    static const KJS::ClassInfo s_info;


    // Custom functions
    KJS::JSValue* debug(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* error(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* info(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* log(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* warn(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* assertCondition(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* profile(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* profileEnd(KJS::ExecState*, const KJS::ArgList&);
    Console* impl() const { return m_impl.get(); }

private:
    RefPtr<Console> m_impl;
};

KJS::JSValue* toJS(KJS::ExecState*, Console*);
Console* toConsole(KJS::JSValue*);

class JSConsolePrototype : public KJS::JSObject {
public:
    static KJS::JSObject* self(KJS::ExecState*);
    virtual const KJS::ClassInfo* classInfo() const { return &s_info; }
    static const KJS::ClassInfo s_info;
    bool getOwnPropertySlot(KJS::ExecState*, const KJS::Identifier&, KJS::PropertySlot&);
    JSConsolePrototype(KJS::ExecState* exec)
        : KJS::JSObject(exec->lexicalGlobalObject()->objectPrototype()) { }
};

// Functions

KJS::JSValue* jsConsolePrototypeFunctionDebug(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsConsolePrototypeFunctionError(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsConsolePrototypeFunctionInfo(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsConsolePrototypeFunctionLog(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsConsolePrototypeFunctionWarn(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsConsolePrototypeFunctionAssert(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsConsolePrototypeFunctionProfile(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsConsolePrototypeFunctionProfileEnd(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
} // namespace WebCore

#endif
