/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSCanvasRenderingContext2D.h"

#include <wtf/GetPtr.h>

#include "CanvasGradient.h"
#include "CanvasPattern.h"
#include "CanvasRenderingContext2D.h"
#include "CanvasStyle.h"
#include "HTMLCanvasElement.h"
#include "ImageData.h"
#include "JSCanvasGradient.h"
#include "JSHTMLCanvasElement.h"
#include "JSImageData.h"
#include "KURL.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCanvasRenderingContext2DTableValues[15] =
{
    { "canvas", (intptr_t)JSCanvasRenderingContext2D::CanvasAttrNum, DontDelete|ReadOnly, 0 },
    { "globalAlpha", (intptr_t)JSCanvasRenderingContext2D::GlobalAlphaAttrNum, DontDelete, 0 },
    { "globalCompositeOperation", (intptr_t)JSCanvasRenderingContext2D::GlobalCompositeOperationAttrNum, DontDelete, 0 },
    { "lineWidth", (intptr_t)JSCanvasRenderingContext2D::LineWidthAttrNum, DontDelete, 0 },
    { "lineCap", (intptr_t)JSCanvasRenderingContext2D::LineCapAttrNum, DontDelete, 0 },
    { "lineJoin", (intptr_t)JSCanvasRenderingContext2D::LineJoinAttrNum, DontDelete, 0 },
    { "miterLimit", (intptr_t)JSCanvasRenderingContext2D::MiterLimitAttrNum, DontDelete, 0 },
    { "shadowOffsetX", (intptr_t)JSCanvasRenderingContext2D::ShadowOffsetXAttrNum, DontDelete, 0 },
    { "shadowOffsetY", (intptr_t)JSCanvasRenderingContext2D::ShadowOffsetYAttrNum, DontDelete, 0 },
    { "shadowBlur", (intptr_t)JSCanvasRenderingContext2D::ShadowBlurAttrNum, DontDelete, 0 },
    { "shadowColor", (intptr_t)JSCanvasRenderingContext2D::ShadowColorAttrNum, DontDelete, 0 },
    { "strokeStyle", (intptr_t)JSCanvasRenderingContext2D::StrokeStyleAttrNum, DontDelete, 0 },
    { "fillStyle", (intptr_t)JSCanvasRenderingContext2D::FillStyleAttrNum, DontDelete, 0 },
    { "constructor", (intptr_t)JSCanvasRenderingContext2D::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCanvasRenderingContext2DTable = { 8191, JSCanvasRenderingContext2DTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSCanvasRenderingContext2DConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSCanvasRenderingContext2DConstructorTable = { 0, JSCanvasRenderingContext2DConstructorTableValues, 0 };

class JSCanvasRenderingContext2DConstructor : public DOMObject {
public:
    JSCanvasRenderingContext2DConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSCanvasRenderingContext2DPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSCanvasRenderingContext2DConstructor::s_info = { "CanvasRenderingContext2DConstructor", 0, &JSCanvasRenderingContext2DConstructorTable, 0 };

bool JSCanvasRenderingContext2DConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCanvasRenderingContext2DConstructor, DOMObject>(exec, &JSCanvasRenderingContext2DConstructorTable, this, propertyName, slot);
}

JSValue* JSCanvasRenderingContext2DConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSCanvasRenderingContext2DPrototypeTableValues[41] =
{
    { "save", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSave, DontDelete|Function, 0 },
    { "restore", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionRestore, DontDelete|Function, 0 },
    { "scale", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionScale, DontDelete|Function, 2 },
    { "rotate", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionRotate, DontDelete|Function, 1 },
    { "translate", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionTranslate, DontDelete|Function, 2 },
    { "transform", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionTransform, DontDelete|Function, 6 },
    { "createLinearGradient", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionCreateLinearGradient, DontDelete|Function, 4 },
    { "createRadialGradient", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionCreateRadialGradient, DontDelete|Function, 6 },
    { "clearRect", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionClearRect, DontDelete|Function, 4 },
    { "fillRect", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionFillRect, DontDelete|Function, 4 },
    { "beginPath", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionBeginPath, DontDelete|Function, 0 },
    { "closePath", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionClosePath, DontDelete|Function, 0 },
    { "moveTo", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionMoveTo, DontDelete|Function, 2 },
    { "lineTo", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionLineTo, DontDelete|Function, 2 },
    { "quadraticCurveTo", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionQuadraticCurveTo, DontDelete|Function, 4 },
    { "bezierCurveTo", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionBezierCurveTo, DontDelete|Function, 6 },
    { "arcTo", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionArcTo, DontDelete|Function, 5 },
    { "rect", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionRect, DontDelete|Function, 4 },
    { "arc", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionArc, DontDelete|Function, 6 },
    { "fill", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionFill, DontDelete|Function, 0 },
    { "stroke", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionStroke, DontDelete|Function, 0 },
    { "clip", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionClip, DontDelete|Function, 0 },
    { "isPointInPath", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath, DontDelete|Function, 2 },
    { "setAlpha", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSetAlpha, DontDelete|Function, 1 },
    { "setCompositeOperation", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSetCompositeOperation, DontDelete|Function, 1 },
    { "setLineWidth", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSetLineWidth, DontDelete|Function, 1 },
    { "setLineCap", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSetLineCap, DontDelete|Function, 1 },
    { "setLineJoin", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSetLineJoin, DontDelete|Function, 1 },
    { "setMiterLimit", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSetMiterLimit, DontDelete|Function, 1 },
    { "clearShadow", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionClearShadow, DontDelete|Function, 0 },
    { "setStrokeColor", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor, DontDelete|Function, 0 },
    { "setFillColor", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSetFillColor, DontDelete|Function, 0 },
    { "strokeRect", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionStrokeRect, DontDelete|Function, 0 },
    { "drawImage", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionDrawImage, DontDelete|Function, 0 },
    { "drawImageFromRect", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionDrawImageFromRect, DontDelete|Function, 0 },
    { "setShadow", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSetShadow, DontDelete|Function, 0 },
    { "createPattern", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionCreatePattern, DontDelete|Function, 0 },
    { "createImageData", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionCreateImageData, DontDelete|Function, 2 },
    { "getImageData", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionGetImageData, DontDelete|Function, 4 },
    { "putImageData", (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionPutImageData, DontDelete|Function, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCanvasRenderingContext2DPrototypeTable = { 4095, JSCanvasRenderingContext2DPrototypeTableValues, 0 };

const ClassInfo JSCanvasRenderingContext2DPrototype::s_info = { "CanvasRenderingContext2DPrototype", 0, &JSCanvasRenderingContext2DPrototypeTable, 0 };

JSObject* JSCanvasRenderingContext2DPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSCanvasRenderingContext2D.prototype]]");
    return KJS::cacheGlobalObject<JSCanvasRenderingContext2DPrototype>(exec, prototypeIdentifier);
}

bool JSCanvasRenderingContext2DPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCanvasRenderingContext2DPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSCanvasRenderingContext2D::s_info = { "CanvasRenderingContext2D", 0, &JSCanvasRenderingContext2DTable , 0 };

JSCanvasRenderingContext2D::JSCanvasRenderingContext2D(JSObject* prototype, CanvasRenderingContext2D* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSCanvasRenderingContext2D::~JSCanvasRenderingContext2D()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSCanvasRenderingContext2D::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCanvasRenderingContext2D, Base>(exec, &JSCanvasRenderingContext2DTable, this, propertyName, slot);
}

JSValue* JSCanvasRenderingContext2D::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CanvasAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        return toJS(exec, WTF::getPtr(imp->canvas()));
    }
    case GlobalAlphaAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        return jsNumber(exec, imp->globalAlpha());
    }
    case GlobalCompositeOperationAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        return jsString(exec, imp->globalCompositeOperation());
    }
    case LineWidthAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        return jsNumber(exec, imp->lineWidth());
    }
    case LineCapAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        return jsString(exec, imp->lineCap());
    }
    case LineJoinAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        return jsString(exec, imp->lineJoin());
    }
    case MiterLimitAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        return jsNumber(exec, imp->miterLimit());
    }
    case ShadowOffsetXAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        return jsNumber(exec, imp->shadowOffsetX());
    }
    case ShadowOffsetYAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        return jsNumber(exec, imp->shadowOffsetY());
    }
    case ShadowBlurAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        return jsNumber(exec, imp->shadowBlur());
    }
    case ShadowColorAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        return jsString(exec, imp->shadowColor());
    }
    case StrokeStyleAttrNum: {
        return strokeStyle(exec);
    }
    case FillStyleAttrNum: {
        return fillStyle(exec);
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSCanvasRenderingContext2D::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSCanvasRenderingContext2D, Base>(exec, propertyName, value, &JSCanvasRenderingContext2DTable, this);
}

void JSCanvasRenderingContext2D::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case GlobalAlphaAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        imp->setGlobalAlpha(value->toFloat(exec));
        break;
    }
    case GlobalCompositeOperationAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        imp->setGlobalCompositeOperation(valueToStringWithNullCheck(exec, value));
        break;
    }
    case LineWidthAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        imp->setLineWidth(value->toFloat(exec));
        break;
    }
    case LineCapAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        imp->setLineCap(valueToStringWithNullCheck(exec, value));
        break;
    }
    case LineJoinAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        imp->setLineJoin(valueToStringWithNullCheck(exec, value));
        break;
    }
    case MiterLimitAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        imp->setMiterLimit(value->toFloat(exec));
        break;
    }
    case ShadowOffsetXAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        imp->setShadowOffsetX(value->toFloat(exec));
        break;
    }
    case ShadowOffsetYAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        imp->setShadowOffsetY(value->toFloat(exec));
        break;
    }
    case ShadowBlurAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        imp->setShadowBlur(value->toFloat(exec));
        break;
    }
    case ShadowColorAttrNum: {
        CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(impl());
        imp->setShadowColor(valueToStringWithNullCheck(exec, value));
        break;
    }
    case StrokeStyleAttrNum: {
        setStrokeStyle(exec, value);
        break;
    }
    case FillStyleAttrNum: {
        setFillStyle(exec, value);
        break;
    }
    }
}

JSValue* JSCanvasRenderingContext2D::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[CanvasRenderingContext2D.constructor]]");
    return KJS::cacheGlobalObject<JSCanvasRenderingContext2DConstructor>(exec, constructorIdentifier);
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionSave(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->save();
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionRestore(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->restore();
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionScale(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float sx = args[0]->toFloat(exec);
    float sy = args[1]->toFloat(exec);

    imp->scale(sx, sy);
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionRotate(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float angle = args[0]->toFloat(exec);

    imp->rotate(angle);
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionTranslate(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float tx = args[0]->toFloat(exec);
    float ty = args[1]->toFloat(exec);

    imp->translate(tx, ty);
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionTransform(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float m11 = args[0]->toFloat(exec);
    float m12 = args[1]->toFloat(exec);
    float m21 = args[2]->toFloat(exec);
    float m22 = args[3]->toFloat(exec);
    float dx = args[4]->toFloat(exec);
    float dy = args[5]->toFloat(exec);

    imp->transform(m11, m12, m21, m22, dx, dy);
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionCreateLinearGradient(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float x0 = args[0]->toFloat(exec);
    float y0 = args[1]->toFloat(exec);
    float x1 = args[2]->toFloat(exec);
    float y1 = args[3]->toFloat(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createLinearGradient(x0, y0, x1, y1)));
    return result;
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionCreateRadialGradient(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float x0 = args[0]->toFloat(exec);
    float y0 = args[1]->toFloat(exec);
    float r0 = args[2]->toFloat(exec);
    float x1 = args[3]->toFloat(exec);
    float y1 = args[4]->toFloat(exec);
    float r1 = args[5]->toFloat(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createRadialGradient(x0, y0, r0, x1, y1, r1)));
    return result;
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionClearRect(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float x = args[0]->toFloat(exec);
    float y = args[1]->toFloat(exec);
    float width = args[2]->toFloat(exec);
    float height = args[3]->toFloat(exec);

    imp->clearRect(x, y, width, height);
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionFillRect(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float x = args[0]->toFloat(exec);
    float y = args[1]->toFloat(exec);
    float width = args[2]->toFloat(exec);
    float height = args[3]->toFloat(exec);

    imp->fillRect(x, y, width, height);
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionBeginPath(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->beginPath();
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionClosePath(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->closePath();
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionMoveTo(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float x = args[0]->toFloat(exec);
    float y = args[1]->toFloat(exec);

    imp->moveTo(x, y);
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionLineTo(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float x = args[0]->toFloat(exec);
    float y = args[1]->toFloat(exec);

    imp->lineTo(x, y);
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionQuadraticCurveTo(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float cpx = args[0]->toFloat(exec);
    float cpy = args[1]->toFloat(exec);
    float x = args[2]->toFloat(exec);
    float y = args[3]->toFloat(exec);

    imp->quadraticCurveTo(cpx, cpy, x, y);
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionBezierCurveTo(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float cp1x = args[0]->toFloat(exec);
    float cp1y = args[1]->toFloat(exec);
    float cp2x = args[2]->toFloat(exec);
    float cp2y = args[3]->toFloat(exec);
    float x = args[4]->toFloat(exec);
    float y = args[5]->toFloat(exec);

    imp->bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionArcTo(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    float x1 = args[0]->toFloat(exec);
    float y1 = args[1]->toFloat(exec);
    float x2 = args[2]->toFloat(exec);
    float y2 = args[3]->toFloat(exec);
    float radius = args[4]->toFloat(exec);

    imp->arcTo(x1, y1, x2, y2, radius, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionRect(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float x = args[0]->toFloat(exec);
    float y = args[1]->toFloat(exec);
    float width = args[2]->toFloat(exec);
    float height = args[3]->toFloat(exec);

    imp->rect(x, y, width, height);
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionArc(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    float x = args[0]->toFloat(exec);
    float y = args[1]->toFloat(exec);
    float radius = args[2]->toFloat(exec);
    float startAngle = args[3]->toFloat(exec);
    float endAngle = args[4]->toFloat(exec);
    bool anticlockwise = args[5]->toBoolean(exec);

    imp->arc(x, y, radius, startAngle, endAngle, anticlockwise, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionFill(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->fill();
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionStroke(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->stroke();
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionClip(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->clip();
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float x = args[0]->toFloat(exec);
    float y = args[1]->toFloat(exec);


    KJS::JSValue* result = jsBoolean(imp->isPointInPath(x, y));
    return result;
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionSetAlpha(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float alpha = args[0]->toFloat(exec);

    imp->setAlpha(alpha);
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionSetCompositeOperation(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    const UString& compositeOperation = args[0]->toString(exec);

    imp->setCompositeOperation(compositeOperation);
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionSetLineWidth(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float width = args[0]->toFloat(exec);

    imp->setLineWidth(width);
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionSetLineCap(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    const UString& cap = args[0]->toString(exec);

    imp->setLineCap(cap);
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionSetLineJoin(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    const UString& join = args[0]->toString(exec);

    imp->setLineJoin(join);
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionSetMiterLimit(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float limit = args[0]->toFloat(exec);

    imp->setMiterLimit(limit);
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionClearShadow(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->clearShadow();
    return jsUndefined();
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    return castedThisObj->setStrokeColor(exec, args);
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionSetFillColor(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    return castedThisObj->setFillColor(exec, args);
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionStrokeRect(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    return castedThisObj->strokeRect(exec, args);
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionDrawImage(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    return castedThisObj->drawImage(exec, args);
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionDrawImageFromRect(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    return castedThisObj->drawImageFromRect(exec, args);
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionSetShadow(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    return castedThisObj->setShadow(exec, args);
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionCreatePattern(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    return castedThisObj->createPattern(exec, args);
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionCreateImageData(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float sw = args[0]->toFloat(exec);
    float sh = args[1]->toFloat(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createImageData(sw, sh)));
    return result;
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionGetImageData(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    float sx = args[0]->toFloat(exec);
    float sy = args[1]->toFloat(exec);
    float sw = args[2]->toFloat(exec);
    float sh = args[3]->toFloat(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getImageData(sx, sy, sw, sh, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsCanvasRenderingContext2DPrototypeFunctionPutImageData(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisValue);
    return castedThisObj->putImageData(exec, args);
}

KJS::JSValue* toJS(KJS::ExecState* exec, CanvasRenderingContext2D* obj)
{
    return cacheDOMObject<CanvasRenderingContext2D, JSCanvasRenderingContext2D, JSCanvasRenderingContext2DPrototype>(exec, obj);
}
CanvasRenderingContext2D* toCanvasRenderingContext2D(KJS::JSValue* val)
{
    return val->isObject(&JSCanvasRenderingContext2D::s_info) ? static_cast<JSCanvasRenderingContext2D*>(val)->impl() : 0;
}

}
