/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSCSSVariablesRule.h"

#include <wtf/GetPtr.h>

#include "CSSVariablesDeclaration.h"
#include "CSSVariablesRule.h"
#include "JSCSSVariablesDeclaration.h"
#include "JSMediaList.h"
#include "MediaList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCSSVariablesRuleTableValues[4] =
{
    { "media", (intptr_t)JSCSSVariablesRule::MediaAttrNum, DontDelete|ReadOnly, 0 },
    { "variables", (intptr_t)JSCSSVariablesRule::VariablesAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSCSSVariablesRule::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSVariablesRuleTable = { 15, JSCSSVariablesRuleTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSCSSVariablesRuleConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSVariablesRuleConstructorTable = { 0, JSCSSVariablesRuleConstructorTableValues, 0 };

class JSCSSVariablesRuleConstructor : public DOMObject {
public:
    JSCSSVariablesRuleConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSCSSVariablesRulePrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSCSSVariablesRuleConstructor::s_info = { "CSSVariablesRuleConstructor", 0, &JSCSSVariablesRuleConstructorTable, 0 };

bool JSCSSVariablesRuleConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSVariablesRuleConstructor, DOMObject>(exec, &JSCSSVariablesRuleConstructorTable, this, propertyName, slot);
}

JSValue* JSCSSVariablesRuleConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSCSSVariablesRulePrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSVariablesRulePrototypeTable = { 0, JSCSSVariablesRulePrototypeTableValues, 0 };

const ClassInfo JSCSSVariablesRulePrototype::s_info = { "CSSVariablesRulePrototype", 0, &JSCSSVariablesRulePrototypeTable, 0 };

JSObject* JSCSSVariablesRulePrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSCSSVariablesRule.prototype]]");
    return KJS::cacheGlobalObject<JSCSSVariablesRulePrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSCSSVariablesRule::s_info = { "CSSVariablesRule", &JSCSSRule::s_info, &JSCSSVariablesRuleTable , 0 };

JSCSSVariablesRule::JSCSSVariablesRule(JSObject* prototype, CSSVariablesRule* impl)
    : JSCSSRule(prototype, impl)
{
}

bool JSCSSVariablesRule::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSVariablesRule, Base>(exec, &JSCSSVariablesRuleTable, this, propertyName, slot);
}

JSValue* JSCSSVariablesRule::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case MediaAttrNum: {
        CSSVariablesRule* imp = static_cast<CSSVariablesRule*>(impl());
        return toJS(exec, WTF::getPtr(imp->media()));
    }
    case VariablesAttrNum: {
        CSSVariablesRule* imp = static_cast<CSSVariablesRule*>(impl());
        return toJS(exec, WTF::getPtr(imp->variables()));
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSCSSVariablesRule::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[CSSVariablesRule.constructor]]");
    return KJS::cacheGlobalObject<JSCSSVariablesRuleConstructor>(exec, constructorIdentifier);
}


}
