/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSCSSStyleSheet.h"

#include <wtf/GetPtr.h>

#include "CSSRule.h"
#include "CSSRuleList.h"
#include "CSSStyleSheet.h"
#include "JSCSSRule.h"
#include "JSCSSRuleList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCSSStyleSheetTableValues[4] =
{
    { "ownerRule", (intptr_t)JSCSSStyleSheet::OwnerRuleAttrNum, DontDelete|ReadOnly, 0 },
    { "cssRules", (intptr_t)JSCSSStyleSheet::CssRulesAttrNum, DontDelete|ReadOnly, 0 },
    { "rules", (intptr_t)JSCSSStyleSheet::RulesAttrNum, DontDelete|ReadOnly, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSStyleSheetTable = { 7, JSCSSStyleSheetTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSCSSStyleSheetPrototypeTableValues[5] =
{
    { "insertRule", (intptr_t)jsCSSStyleSheetPrototypeFunctionInsertRule, DontDelete|Function, 2 },
    { "deleteRule", (intptr_t)jsCSSStyleSheetPrototypeFunctionDeleteRule, DontDelete|Function, 1 },
    { "addRule", (intptr_t)jsCSSStyleSheetPrototypeFunctionAddRule, DontDelete|Function, 3 },
    { "removeRule", (intptr_t)jsCSSStyleSheetPrototypeFunctionRemoveRule, DontDelete|Function, 1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSStyleSheetPrototypeTable = { 7, JSCSSStyleSheetPrototypeTableValues, 0 };

const ClassInfo JSCSSStyleSheetPrototype::s_info = { "CSSStyleSheetPrototype", 0, &JSCSSStyleSheetPrototypeTable, 0 };

JSObject* JSCSSStyleSheetPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSCSSStyleSheet.prototype]]");
    return KJS::cacheGlobalObject<JSCSSStyleSheetPrototype>(exec, prototypeIdentifier);
}

bool JSCSSStyleSheetPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSStyleSheetPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSCSSStyleSheet::s_info = { "CSSStyleSheet", &JSStyleSheet::s_info, &JSCSSStyleSheetTable , 0 };

JSCSSStyleSheet::JSCSSStyleSheet(JSObject* prototype, CSSStyleSheet* impl)
    : JSStyleSheet(prototype, impl)
{
}

bool JSCSSStyleSheet::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSStyleSheet, Base>(exec, &JSCSSStyleSheetTable, this, propertyName, slot);
}

JSValue* JSCSSStyleSheet::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case OwnerRuleAttrNum: {
        CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(impl());
        return toJS(exec, WTF::getPtr(imp->ownerRule()));
    }
    case CssRulesAttrNum: {
        CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(impl());
        return toJS(exec, WTF::getPtr(imp->cssRules()));
    }
    case RulesAttrNum: {
        CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(impl());
        return toJS(exec, WTF::getPtr(imp->rules()));
    }
    }
    return 0;
}

JSValue* jsCSSStyleSheetPrototypeFunctionInsertRule(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSStyleSheet::s_info))
        return throwError(exec, TypeError);
    JSCSSStyleSheet* castedThisObj = static_cast<JSCSSStyleSheet*>(thisValue);
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& rule = args[0]->toString(exec);
    unsigned index = args[1]->toInt32(exec);


    KJS::JSValue* result = jsNumber(exec, imp->insertRule(rule, index, ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsCSSStyleSheetPrototypeFunctionDeleteRule(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSStyleSheet::s_info))
        return throwError(exec, TypeError);
    JSCSSStyleSheet* castedThisObj = static_cast<JSCSSStyleSheet*>(thisValue);
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned index = args[0]->toInt32(exec);

    imp->deleteRule(index, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsCSSStyleSheetPrototypeFunctionAddRule(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSStyleSheet::s_info))
        return throwError(exec, TypeError);
    JSCSSStyleSheet* castedThisObj = static_cast<JSCSSStyleSheet*>(thisValue);
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& selector = args[0]->toString(exec);
    const UString& style = args[1]->toString(exec);

    int argsCount = args.size();
    if (argsCount < 3) {

        KJS::JSValue* result = jsNumber(exec, imp->addRule(selector, style, ec));
        setDOMException(exec, ec);
        return result;
    }

    unsigned index = args[2]->toInt32(exec);


    KJS::JSValue* result = jsNumber(exec, imp->addRule(selector, style, index, ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsCSSStyleSheetPrototypeFunctionRemoveRule(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSStyleSheet::s_info))
        return throwError(exec, TypeError);
    JSCSSStyleSheet* castedThisObj = static_cast<JSCSSStyleSheet*>(thisValue);
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned index = args[0]->toInt32(exec);

    imp->removeRule(index, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}


}
