/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSCSSStyleRule.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSStyleRule.h"
#include "JSCSSStyleDeclaration.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCSSStyleRuleTableValues[4] =
{
    { "selectorText", (intptr_t)JSCSSStyleRule::SelectorTextAttrNum, DontDelete, 0 },
    { "style", (intptr_t)JSCSSStyleRule::StyleAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSCSSStyleRule::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSStyleRuleTable = { 7, JSCSSStyleRuleTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSCSSStyleRuleConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSStyleRuleConstructorTable = { 0, JSCSSStyleRuleConstructorTableValues, 0 };

class JSCSSStyleRuleConstructor : public DOMObject {
public:
    JSCSSStyleRuleConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSCSSStyleRulePrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSCSSStyleRuleConstructor::s_info = { "CSSStyleRuleConstructor", 0, &JSCSSStyleRuleConstructorTable, 0 };

bool JSCSSStyleRuleConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSStyleRuleConstructor, DOMObject>(exec, &JSCSSStyleRuleConstructorTable, this, propertyName, slot);
}

JSValue* JSCSSStyleRuleConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSCSSStyleRulePrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSStyleRulePrototypeTable = { 0, JSCSSStyleRulePrototypeTableValues, 0 };

const ClassInfo JSCSSStyleRulePrototype::s_info = { "CSSStyleRulePrototype", 0, &JSCSSStyleRulePrototypeTable, 0 };

JSObject* JSCSSStyleRulePrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSCSSStyleRule.prototype]]");
    return KJS::cacheGlobalObject<JSCSSStyleRulePrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSCSSStyleRule::s_info = { "CSSStyleRule", &JSCSSRule::s_info, &JSCSSStyleRuleTable , 0 };

JSCSSStyleRule::JSCSSStyleRule(JSObject* prototype, CSSStyleRule* impl)
    : JSCSSRule(prototype, impl)
{
}

bool JSCSSStyleRule::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSStyleRule, Base>(exec, &JSCSSStyleRuleTable, this, propertyName, slot);
}

JSValue* JSCSSStyleRule::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case SelectorTextAttrNum: {
        CSSStyleRule* imp = static_cast<CSSStyleRule*>(impl());
        return jsStringOrNull(exec, imp->selectorText());
    }
    case StyleAttrNum: {
        CSSStyleRule* imp = static_cast<CSSStyleRule*>(impl());
        return toJS(exec, WTF::getPtr(imp->style()));
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSCSSStyleRule::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSCSSStyleRule, Base>(exec, propertyName, value, &JSCSSStyleRuleTable, this);
}

void JSCSSStyleRule::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case SelectorTextAttrNum: {
        CSSStyleRule* imp = static_cast<CSSStyleRule*>(impl());
        ExceptionCode ec = 0;
        imp->setSelectorText(valueToStringWithNullCheck(exec, value), ec);
        setDOMException(exec, ec);
        break;
    }
    }
}

JSValue* JSCSSStyleRule::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[CSSStyleRule.constructor]]");
    return KJS::cacheGlobalObject<JSCSSStyleRuleConstructor>(exec, constructorIdentifier);
}


}
