/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSCSSRuleList.h"

#include <wtf/GetPtr.h>

#include <kjs/PropertyNameArray.h>
#include "CSSRule.h"
#include "CSSRuleList.h"
#include "JSCSSRule.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCSSRuleListTableValues[3] =
{
    { "length", (intptr_t)JSCSSRuleList::LengthAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSCSSRuleList::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSRuleListTable = { 15, JSCSSRuleListTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSCSSRuleListConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSRuleListConstructorTable = { 0, JSCSSRuleListConstructorTableValues, 0 };

class JSCSSRuleListConstructor : public DOMObject {
public:
    JSCSSRuleListConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSCSSRuleListPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSCSSRuleListConstructor::s_info = { "CSSRuleListConstructor", 0, &JSCSSRuleListConstructorTable, 0 };

bool JSCSSRuleListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSRuleListConstructor, DOMObject>(exec, &JSCSSRuleListConstructorTable, this, propertyName, slot);
}

JSValue* JSCSSRuleListConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSCSSRuleListPrototypeTableValues[2] =
{
    { "item", (intptr_t)jsCSSRuleListPrototypeFunctionItem, DontDelete|Function, 1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSRuleListPrototypeTable = { 0, JSCSSRuleListPrototypeTableValues, 0 };

const ClassInfo JSCSSRuleListPrototype::s_info = { "CSSRuleListPrototype", 0, &JSCSSRuleListPrototypeTable, 0 };

JSObject* JSCSSRuleListPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSCSSRuleList.prototype]]");
    return KJS::cacheGlobalObject<JSCSSRuleListPrototype>(exec, prototypeIdentifier);
}

bool JSCSSRuleListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSRuleListPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSCSSRuleList::s_info = { "CSSRuleList", 0, &JSCSSRuleListTable , 0 };

JSCSSRuleList::JSCSSRuleList(JSObject* prototype, CSSRuleList* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSCSSRuleList::~JSCSSRuleList()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSCSSRuleList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = JSCSSRuleListTable.entry(exec, propertyName);
    if (entry) {
        slot.setStaticEntry(this, entry, staticValueGetter<JSCSSRuleList>);
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<CSSRuleList*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSCSSRuleList, Base>(exec, &JSCSSRuleListTable, this, propertyName, slot);
}

bool JSCSSRuleList::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<CSSRuleList*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue* JSCSSRuleList::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case LengthAttrNum: {
        CSSRuleList* imp = static_cast<CSSRuleList*>(impl());
        return jsNumber(exec, imp->length());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSCSSRuleList::getPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    for (unsigned i = 0; i < static_cast<CSSRuleList*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getPropertyNames(exec, propertyNames);
}

JSValue* JSCSSRuleList::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[CSSRuleList.constructor]]");
    return KJS::cacheGlobalObject<JSCSSRuleListConstructor>(exec, constructorIdentifier);
}

JSValue* jsCSSRuleListPrototypeFunctionItem(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSRuleList::s_info))
        return throwError(exec, TypeError);
    JSCSSRuleList* castedThisObj = static_cast<JSCSSRuleList*>(thisValue);
    CSSRuleList* imp = static_cast<CSSRuleList*>(castedThisObj->impl());
    unsigned index = args[0]->toInt32(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->item(index)));
    return result;
}


JSValue* JSCSSRuleList::indexGetter(ExecState* exec, const Identifier& propertyName, const PropertySlot& slot)
{
    JSCSSRuleList* thisObj = static_cast<JSCSSRuleList*>(slot.slotBase());
    return toJS(exec, static_cast<CSSRuleList*>(thisObj->impl())->item(slot.index()));
}
KJS::JSValue* toJS(KJS::ExecState* exec, CSSRuleList* obj)
{
    return cacheDOMObject<CSSRuleList, JSCSSRuleList, JSCSSRuleListPrototype>(exec, obj);
}
CSSRuleList* toCSSRuleList(KJS::JSValue* val)
{
    return val->isObject(&JSCSSRuleList::s_info) ? static_cast<JSCSSRuleList*>(val)->impl() : 0;
}

}
