/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSCSSMediaRule.h"

#include <wtf/GetPtr.h>

#include "CSSMediaRule.h"
#include "CSSRuleList.h"
#include "JSCSSRuleList.h"
#include "JSMediaList.h"
#include "MediaList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCSSMediaRuleTableValues[4] =
{
    { "media", (intptr_t)JSCSSMediaRule::MediaAttrNum, DontDelete|ReadOnly, 0 },
    { "cssRules", (intptr_t)JSCSSMediaRule::CssRulesAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSCSSMediaRule::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSMediaRuleTable = { 7, JSCSSMediaRuleTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSCSSMediaRuleConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSMediaRuleConstructorTable = { 0, JSCSSMediaRuleConstructorTableValues, 0 };

class JSCSSMediaRuleConstructor : public DOMObject {
public:
    JSCSSMediaRuleConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSCSSMediaRulePrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSCSSMediaRuleConstructor::s_info = { "CSSMediaRuleConstructor", 0, &JSCSSMediaRuleConstructorTable, 0 };

bool JSCSSMediaRuleConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSMediaRuleConstructor, DOMObject>(exec, &JSCSSMediaRuleConstructorTable, this, propertyName, slot);
}

JSValue* JSCSSMediaRuleConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSCSSMediaRulePrototypeTableValues[3] =
{
    { "insertRule", (intptr_t)jsCSSMediaRulePrototypeFunctionInsertRule, DontDelete|Function, 2 },
    { "deleteRule", (intptr_t)jsCSSMediaRulePrototypeFunctionDeleteRule, DontDelete|Function, 1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSMediaRulePrototypeTable = { 1, JSCSSMediaRulePrototypeTableValues, 0 };

const ClassInfo JSCSSMediaRulePrototype::s_info = { "CSSMediaRulePrototype", 0, &JSCSSMediaRulePrototypeTable, 0 };

JSObject* JSCSSMediaRulePrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSCSSMediaRule.prototype]]");
    return KJS::cacheGlobalObject<JSCSSMediaRulePrototype>(exec, prototypeIdentifier);
}

bool JSCSSMediaRulePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSMediaRulePrototypeTable, this, propertyName, slot);
}

const ClassInfo JSCSSMediaRule::s_info = { "CSSMediaRule", &JSCSSRule::s_info, &JSCSSMediaRuleTable , 0 };

JSCSSMediaRule::JSCSSMediaRule(JSObject* prototype, CSSMediaRule* impl)
    : JSCSSRule(prototype, impl)
{
}

bool JSCSSMediaRule::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSMediaRule, Base>(exec, &JSCSSMediaRuleTable, this, propertyName, slot);
}

JSValue* JSCSSMediaRule::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case MediaAttrNum: {
        CSSMediaRule* imp = static_cast<CSSMediaRule*>(impl());
        return toJS(exec, WTF::getPtr(imp->media()));
    }
    case CssRulesAttrNum: {
        CSSMediaRule* imp = static_cast<CSSMediaRule*>(impl());
        return toJS(exec, WTF::getPtr(imp->cssRules()));
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSCSSMediaRule::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[CSSMediaRule.constructor]]");
    return KJS::cacheGlobalObject<JSCSSMediaRuleConstructor>(exec, constructorIdentifier);
}

JSValue* jsCSSMediaRulePrototypeFunctionInsertRule(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSMediaRule::s_info))
        return throwError(exec, TypeError);
    JSCSSMediaRule* castedThisObj = static_cast<JSCSSMediaRule*>(thisValue);
    CSSMediaRule* imp = static_cast<CSSMediaRule*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& rule = args[0]->toString(exec);
    unsigned index = args[1]->toInt32(exec);


    KJS::JSValue* result = jsNumber(exec, imp->insertRule(rule, index, ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsCSSMediaRulePrototypeFunctionDeleteRule(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSMediaRule::s_info))
        return throwError(exec, TypeError);
    JSCSSMediaRule* castedThisObj = static_cast<JSCSSMediaRule*>(thisValue);
    CSSMediaRule* imp = static_cast<CSSMediaRule*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned index = args[0]->toInt32(exec);

    imp->deleteRule(index, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}


}
