/*
 * Copyright (C) 2006, 2007, 2008 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer. 
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 * 3.  Neither the name of Apple Computer, Inc. ("Apple") nor the names of
 *     its contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
* This file was modified by Electronic Arts Inc Copyright  2008-2009
*/


///////////////////////////////////////////////////////////////////////////////
// BCFileChooserEA.h
// Modified by Paul Pedriana
///////////////////////////////////////////////////////////////////////////////


#ifndef FileChooser_h
#define FileChooser_h


#include "PlatformString.h"


namespace OWBAL {


class Document;
class Font;
class Icon;


class FileChooserClient {
public:
    virtual ~FileChooserClient() { }
    virtual void valueChanged() = 0;
};


class FileChooser : public RefCounted<FileChooser> {
public:
    static PassRefPtr<FileChooser> create(FileChooserClient*, const String& initialFilename);
    ~FileChooser();

    void disconnectClient() { m_client = 0; }
    bool disconnected() { return !m_client; }

    // FIXME: It's a layering violation that we pass a Document in here.
    // The platform directory is underneath the DOM, so it can't use the DOM.
    // Because of UI delegates, it's not clear that the FileChooser class
    // belongs in the platform layer at all. It might need to go alongside
    // the Chrome class instead.
    void openFileChooser(Document*);

    const String& filename() const { return m_filename; }
    String basenameForWidth(const Font&, int width) const;

    Icon* icon() const { return m_icon.get(); }

    void clear(); // for use by client; does not call valueChanged

    void chooseFile(const String& filename);

private:
    FileChooser(FileChooserClient*, const String& initialFilename);
    static PassRefPtr<Icon> chooseIcon(const String& filename);

    FileChooserClient* m_client;
    String m_filename;
    RefPtr<Icon> m_icon;
};

}

#endif
