/*
Copyright (C) 2009 Electronic Arts, Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1.  Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
2.  Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.
3.  Neither the name of Electronic Arts, Inc. ("EA") nor the names of
    its contributors may be used to endorse or promote products derived
    from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY ELECTRONIC ARTS AND ITS CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL ELECTRONIC ARTS OR ITS CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

// UnicodeData.inl


namespace EA
{

namespace Text
{


// NFD decomposition entries
// All of these are 1 char -> 2 char. The Unicode standard defines additional 
// decompositions, and some of them are 1 -> 3 and even 1 -> 4 char decompositions, 
// but all of them happen to be very unusual characters of little interest to us.
// These entries were generated from the NormalizationTest.txt document that comes
// with the Unicode Standard data.

struct NFDEntry  // Normalization Form D (canonical decomposition)
{
    Char mChar;
    Char mD0;
    Char mD1;
};

const NFDEntry gNFDEntryArray[] = 
{ 
    { 0x00C0, 0x0041, 0x0300 },     // To do: Allow this to be trimmed down via 
    { 0x00C1, 0x0041, 0x0301 },     // some configuration #defines.
    { 0x00C2, 0x0041, 0x0302 },
    { 0x00C3, 0x0041, 0x0303 },
    { 0x00C4, 0x0041, 0x0308 },
    { 0x00C5, 0x0041, 0x030A },
    { 0x00C7, 0x0043, 0x0327 },
    { 0x00C8, 0x0045, 0x0300 },
    { 0x00C9, 0x0045, 0x0301 },
    { 0x00CA, 0x0045, 0x0302 },
    { 0x00CB, 0x0045, 0x0308 },
    { 0x00CC, 0x0049, 0x0300 },
    { 0x00CD, 0x0049, 0x0301 },
    { 0x00CE, 0x0049, 0x0302 },
    { 0x00CF, 0x0049, 0x0308 },
    { 0x00D1, 0x004E, 0x0303 },
    { 0x00D2, 0x004F, 0x0300 },
    { 0x00D3, 0x004F, 0x0301 },
    { 0x00D4, 0x004F, 0x0302 },
    { 0x00D5, 0x004F, 0x0303 },
    { 0x00D6, 0x004F, 0x0308 },
    { 0x00D9, 0x0055, 0x0300 },
    { 0x00DA, 0x0055, 0x0301 },
    { 0x00DB, 0x0055, 0x0302 },
    { 0x00DC, 0x0055, 0x0308 },
    { 0x00DD, 0x0059, 0x0301 },
    { 0x00E0, 0x0061, 0x0300 },
    { 0x00E1, 0x0061, 0x0301 },
    { 0x00E2, 0x0061, 0x0302 },
    { 0x00E3, 0x0061, 0x0303 },
    { 0x00E4, 0x0061, 0x0308 },
    { 0x00E5, 0x0061, 0x030A },
    { 0x00E7, 0x0063, 0x0327 },
    { 0x00E8, 0x0065, 0x0300 },
    { 0x00E9, 0x0065, 0x0301 },
    { 0x00EA, 0x0065, 0x0302 },
    { 0x00EB, 0x0065, 0x0308 },
    { 0x00EC, 0x0069, 0x0300 },
    { 0x00ED, 0x0069, 0x0301 },
    { 0x00EE, 0x0069, 0x0302 },
    { 0x00EF, 0x0069, 0x0308 },
    { 0x00F1, 0x006E, 0x0303 },
    { 0x00F2, 0x006F, 0x0300 },
    { 0x00F3, 0x006F, 0x0301 },
    { 0x00F4, 0x006F, 0x0302 },
    { 0x00F5, 0x006F, 0x0303 },
    { 0x00F6, 0x006F, 0x0308 },
    { 0x00F9, 0x0075, 0x0300 },
    { 0x00FA, 0x0075, 0x0301 },
    { 0x00FB, 0x0075, 0x0302 },
    { 0x00FC, 0x0075, 0x0308 },
    { 0x00FD, 0x0079, 0x0301 },
    { 0x00FF, 0x0079, 0x0308 },
    { 0x0100, 0x0041, 0x0304 },
    { 0x0101, 0x0061, 0x0304 },
    { 0x0102, 0x0041, 0x0306 },
    { 0x0103, 0x0061, 0x0306 },
    { 0x0104, 0x0041, 0x0328 },
    { 0x0105, 0x0061, 0x0328 },
    { 0x0106, 0x0043, 0x0301 },
    { 0x0107, 0x0063, 0x0301 },
    { 0x0108, 0x0043, 0x0302 },
    { 0x0109, 0x0063, 0x0302 },
    { 0x010A, 0x0043, 0x0307 },
    { 0x010B, 0x0063, 0x0307 },
    { 0x010C, 0x0043, 0x030C },
    { 0x010D, 0x0063, 0x030C },
    { 0x010E, 0x0044, 0x030C },
    { 0x010F, 0x0064, 0x030C },
    { 0x0112, 0x0045, 0x0304 },
    { 0x0113, 0x0065, 0x0304 },
    { 0x0114, 0x0045, 0x0306 },
    { 0x0115, 0x0065, 0x0306 },
    { 0x0116, 0x0045, 0x0307 },
    { 0x0117, 0x0065, 0x0307 },
    { 0x0118, 0x0045, 0x0328 },
    { 0x0119, 0x0065, 0x0328 },
    { 0x011A, 0x0045, 0x030C },
    { 0x011B, 0x0065, 0x030C },
    { 0x011C, 0x0047, 0x0302 },
    { 0x011D, 0x0067, 0x0302 },
    { 0x011E, 0x0047, 0x0306 },
    { 0x011F, 0x0067, 0x0306 },
    { 0x0120, 0x0047, 0x0307 },
    { 0x0121, 0x0067, 0x0307 },
    { 0x0122, 0x0047, 0x0327 },
    { 0x0123, 0x0067, 0x0327 },
    { 0x0124, 0x0048, 0x0302 },
    { 0x0125, 0x0068, 0x0302 },
    { 0x0128, 0x0049, 0x0303 },
    { 0x0129, 0x0069, 0x0303 },
    { 0x012A, 0x0049, 0x0304 },
    { 0x012B, 0x0069, 0x0304 },
    { 0x012C, 0x0049, 0x0306 },
    { 0x012D, 0x0069, 0x0306 },
    { 0x012E, 0x0049, 0x0328 },
    { 0x012F, 0x0069, 0x0328 },
    { 0x0130, 0x0049, 0x0307 },
    { 0x0134, 0x004A, 0x0302 },
    { 0x0135, 0x006A, 0x0302 },
    { 0x0136, 0x004B, 0x0327 },
    { 0x0137, 0x006B, 0x0327 },
    { 0x0139, 0x004C, 0x0301 },
    { 0x013A, 0x006C, 0x0301 },
    { 0x013B, 0x004C, 0x0327 },
    { 0x013C, 0x006C, 0x0327 },
    { 0x013D, 0x004C, 0x030C },
    { 0x013E, 0x006C, 0x030C },
    { 0x0143, 0x004E, 0x0301 },
    { 0x0144, 0x006E, 0x0301 },
    { 0x0145, 0x004E, 0x0327 },
    { 0x0146, 0x006E, 0x0327 },
    { 0x0147, 0x004E, 0x030C },
    { 0x0148, 0x006E, 0x030C },
    { 0x014C, 0x004F, 0x0304 },
    { 0x014D, 0x006F, 0x0304 },
    { 0x014E, 0x004F, 0x0306 },
    { 0x014F, 0x006F, 0x0306 },
    { 0x0150, 0x004F, 0x030B },
    { 0x0151, 0x006F, 0x030B },
    { 0x0154, 0x0052, 0x0301 },
    { 0x0155, 0x0072, 0x0301 },
    { 0x0156, 0x0052, 0x0327 },
    { 0x0157, 0x0072, 0x0327 },
    { 0x0158, 0x0052, 0x030C },
    { 0x0159, 0x0072, 0x030C },
    { 0x015A, 0x0053, 0x0301 },
    { 0x015B, 0x0073, 0x0301 },
    { 0x015C, 0x0053, 0x0302 },
    { 0x015D, 0x0073, 0x0302 },
    { 0x015E, 0x0053, 0x0327 },
    { 0x015F, 0x0073, 0x0327 },
    { 0x0160, 0x0053, 0x030C },
    { 0x0161, 0x0073, 0x030C },
    { 0x0162, 0x0054, 0x0327 },
    { 0x0163, 0x0074, 0x0327 },
    { 0x0164, 0x0054, 0x030C },
    { 0x0165, 0x0074, 0x030C },
    { 0x0168, 0x0055, 0x0303 },
    { 0x0169, 0x0075, 0x0303 },
    { 0x016A, 0x0055, 0x0304 },
    { 0x016B, 0x0075, 0x0304 },
    { 0x016C, 0x0055, 0x0306 },
    { 0x016D, 0x0075, 0x0306 },
    { 0x016E, 0x0055, 0x030A },
    { 0x016F, 0x0075, 0x030A },
    { 0x0170, 0x0055, 0x030B },
    { 0x0171, 0x0075, 0x030B },
    { 0x0172, 0x0055, 0x0328 },
    { 0x0173, 0x0075, 0x0328 },
    { 0x0174, 0x0057, 0x0302 },
    { 0x0175, 0x0077, 0x0302 },
    { 0x0176, 0x0059, 0x0302 },
    { 0x0177, 0x0079, 0x0302 },
    { 0x0178, 0x0059, 0x0308 },
    { 0x0179, 0x005A, 0x0301 },
    { 0x017A, 0x007A, 0x0301 },
    { 0x017B, 0x005A, 0x0307 },
    { 0x017C, 0x007A, 0x0307 },
    { 0x017D, 0x005A, 0x030C },
    { 0x017E, 0x007A, 0x030C },
    { 0x01A0, 0x004F, 0x031B },
    { 0x01A1, 0x006F, 0x031B },
    { 0x01AF, 0x0055, 0x031B },
    { 0x01B0, 0x0075, 0x031B },
    { 0x01CD, 0x0041, 0x030C },
    { 0x01CE, 0x0061, 0x030C },
    { 0x01CF, 0x0049, 0x030C },
    { 0x01D0, 0x0069, 0x030C },
    { 0x01D1, 0x004F, 0x030C },
    { 0x01D2, 0x006F, 0x030C },
    { 0x01D3, 0x0055, 0x030C },
    { 0x01D4, 0x0075, 0x030C },
    { 0x01D5, 0x0055, 0x0308 },
    { 0x01D6, 0x0075, 0x0308 },
    { 0x01D7, 0x0055, 0x0308 },
    { 0x01D8, 0x0075, 0x0308 },
    { 0x01D9, 0x0055, 0x0308 },
    { 0x01DA, 0x0075, 0x0308 },
    { 0x01DB, 0x0055, 0x0308 },
    { 0x01DC, 0x0075, 0x0308 },
    { 0x01DE, 0x0041, 0x0308 },
    { 0x01DF, 0x0061, 0x0308 },
    { 0x01E0, 0x0041, 0x0307 },
    { 0x01E1, 0x0061, 0x0307 },
    { 0x01E2, 0x00C6, 0x0304 },
    { 0x01E3, 0x00E6, 0x0304 },
    { 0x01E6, 0x0047, 0x030C },
    { 0x01E7, 0x0067, 0x030C },
    { 0x01E8, 0x004B, 0x030C },
    { 0x01E9, 0x006B, 0x030C },
    { 0x01EA, 0x004F, 0x0328 },
    { 0x01EB, 0x006F, 0x0328 },
    { 0x01EC, 0x004F, 0x0328 },
    { 0x01ED, 0x006F, 0x0328 },
    { 0x01EE, 0x01B7, 0x030C },
    { 0x01EF, 0x0292, 0x030C },
    { 0x01F0, 0x006A, 0x030C },
    { 0x01F4, 0x0047, 0x0301 },
    { 0x01F5, 0x0067, 0x0301 },
    { 0x01F8, 0x004E, 0x0300 },
    { 0x01F9, 0x006E, 0x0300 },
    { 0x01FA, 0x0041, 0x030A },
    { 0x01FB, 0x0061, 0x030A },
    { 0x01FC, 0x00C6, 0x0301 },
    { 0x01FD, 0x00E6, 0x0301 },
    { 0x01FE, 0x00D8, 0x0301 },
    { 0x01FF, 0x00F8, 0x0301 },
    { 0x0200, 0x0041, 0x030F },
    { 0x0201, 0x0061, 0x030F },
    { 0x0202, 0x0041, 0x0311 },
    { 0x0203, 0x0061, 0x0311 },
    { 0x0204, 0x0045, 0x030F },
    { 0x0205, 0x0065, 0x030F },
    { 0x0206, 0x0045, 0x0311 },
    { 0x0207, 0x0065, 0x0311 },
    { 0x0208, 0x0049, 0x030F },
    { 0x0209, 0x0069, 0x030F },
    { 0x020A, 0x0049, 0x0311 },
    { 0x020B, 0x0069, 0x0311 },
    { 0x020C, 0x004F, 0x030F },
    { 0x020D, 0x006F, 0x030F },
    { 0x020E, 0x004F, 0x0311 },
    { 0x020F, 0x006F, 0x0311 },
    { 0x0210, 0x0052, 0x030F },
    { 0x0211, 0x0072, 0x030F },
    { 0x0212, 0x0052, 0x0311 },
    { 0x0213, 0x0072, 0x0311 },
    { 0x0214, 0x0055, 0x030F },
    { 0x0215, 0x0075, 0x030F },
    { 0x0216, 0x0055, 0x0311 },
    { 0x0217, 0x0075, 0x0311 },
    { 0x0218, 0x0053, 0x0326 },
    { 0x0219, 0x0073, 0x0326 },
    { 0x021A, 0x0054, 0x0326 },
    { 0x021B, 0x0074, 0x0326 },
    { 0x021E, 0x0048, 0x030C },
    { 0x021F, 0x0068, 0x030C },
    { 0x0226, 0x0041, 0x0307 },
    { 0x0227, 0x0061, 0x0307 },
    { 0x0228, 0x0045, 0x0327 },
    { 0x0229, 0x0065, 0x0327 },
    { 0x022A, 0x004F, 0x0308 },
    { 0x022B, 0x006F, 0x0308 },
    { 0x022C, 0x004F, 0x0303 },
    { 0x022D, 0x006F, 0x0303 },
    { 0x022E, 0x004F, 0x0307 },
    { 0x022F, 0x006F, 0x0307 },
    { 0x0230, 0x004F, 0x0307 },
    { 0x0231, 0x006F, 0x0307 },
    { 0x0232, 0x0059, 0x0304 },
    { 0x0233, 0x0079, 0x0304 },
    { 0x0344, 0x0301, 0x0308 },
    { 0x0385, 0x00A8, 0x0301 },
    { 0x0386, 0x0391, 0x0301 },
    { 0x0388, 0x0395, 0x0301 },
    { 0x0389, 0x0397, 0x0301 },
    { 0x038A, 0x0399, 0x0301 },
    { 0x038C, 0x039F, 0x0301 },
    { 0x038E, 0x03A5, 0x0301 },
    { 0x038F, 0x03A9, 0x0301 },
    { 0x0390, 0x03B9, 0x0308 },
    { 0x03AA, 0x0399, 0x0308 },
    { 0x03AB, 0x03A5, 0x0308 },
    { 0x03AC, 0x03B1, 0x0301 },
    { 0x03AD, 0x03B5, 0x0301 },
    { 0x03AE, 0x03B7, 0x0301 },
    { 0x03AF, 0x03B9, 0x0301 },
    { 0x03B0, 0x03C5, 0x0308 },
    { 0x03CA, 0x03B9, 0x0308 },
    { 0x03CB, 0x03C5, 0x0308 },
    { 0x03CC, 0x03BF, 0x0301 },
    { 0x03CD, 0x03C5, 0x0301 },
    { 0x03CE, 0x03C9, 0x0301 },
    { 0x03D3, 0x03D2, 0x0301 },
    { 0x03D4, 0x03D2, 0x0308 },
    { 0x0400, 0x0415, 0x0300 },
    { 0x0401, 0x0415, 0x0308 },
    { 0x0403, 0x0413, 0x0301 },
    { 0x0407, 0x0406, 0x0308 },
    { 0x040C, 0x041A, 0x0301 },
    { 0x040D, 0x0418, 0x0300 },
    { 0x040E, 0x0423, 0x0306 },
    { 0x0419, 0x0418, 0x0306 },
    { 0x0439, 0x0438, 0x0306 },
    { 0x0450, 0x0435, 0x0300 },
    { 0x0451, 0x0435, 0x0308 },
    { 0x0453, 0x0433, 0x0301 },
    { 0x0457, 0x0456, 0x0308 },
    { 0x045C, 0x043A, 0x0301 },
    { 0x045D, 0x0438, 0x0300 },
    { 0x045E, 0x0443, 0x0306 },
    { 0x0476, 0x0474, 0x030F },
    { 0x0477, 0x0475, 0x030F },
    { 0x04C1, 0x0416, 0x0306 },
    { 0x04C2, 0x0436, 0x0306 },
    { 0x04D0, 0x0410, 0x0306 },
    { 0x04D1, 0x0430, 0x0306 },
    { 0x04D2, 0x0410, 0x0308 },
    { 0x04D3, 0x0430, 0x0308 },
    { 0x04D6, 0x0415, 0x0306 },
    { 0x04D7, 0x0435, 0x0306 },
    { 0x04DA, 0x04D8, 0x0308 },
    { 0x04DB, 0x04D9, 0x0308 },
    { 0x04DC, 0x0416, 0x0308 },
    { 0x04DD, 0x0436, 0x0308 },
    { 0x04DE, 0x0417, 0x0308 },
    { 0x04DF, 0x0437, 0x0308 },
    { 0x04E2, 0x0418, 0x0304 },
    { 0x04E3, 0x0438, 0x0304 },
    { 0x04E4, 0x0418, 0x0308 },
    { 0x04E5, 0x0438, 0x0308 },
    { 0x04E6, 0x041E, 0x0308 },
    { 0x04E7, 0x043E, 0x0308 },
    { 0x04EA, 0x04E8, 0x0308 },
    { 0x04EB, 0x04E9, 0x0308 },
    { 0x04EC, 0x042D, 0x0308 },
    { 0x04ED, 0x044D, 0x0308 },
    { 0x04EE, 0x0423, 0x0304 },
    { 0x04EF, 0x0443, 0x0304 },
    { 0x04F0, 0x0423, 0x0308 },
    { 0x04F1, 0x0443, 0x0308 },
    { 0x04F2, 0x0423, 0x030B },
    { 0x04F3, 0x0443, 0x030B },
    { 0x04F4, 0x0427, 0x0308 },
    { 0x04F5, 0x0447, 0x0308 },
    { 0x04F8, 0x042B, 0x0308 },
    { 0x04F9, 0x044B, 0x0308 },
    { 0x0622, 0x0627, 0x0653 },
    { 0x0623, 0x0627, 0x0654 },
    { 0x0624, 0x0648, 0x0654 },
    { 0x0625, 0x0627, 0x0655 },
    { 0x0626, 0x064A, 0x0654 },
    { 0x06C0, 0x06D5, 0x0654 },
    { 0x06C2, 0x06C1, 0x0654 },
    { 0x06D3, 0x06D2, 0x0654 },
    { 0x0929, 0x0928, 0x093C },
    { 0x0931, 0x0930, 0x093C },
    { 0x0934, 0x0933, 0x093C },
    { 0x0958, 0x093C, 0x0915 },
    { 0x0959, 0x093C, 0x0916 },
    { 0x095A, 0x093C, 0x0917 },
    { 0x095B, 0x093C, 0x091C },
    { 0x095C, 0x093C, 0x0921 },
    { 0x095D, 0x093C, 0x0922 },
    { 0x095E, 0x093C, 0x092B },
    { 0x095F, 0x093C, 0x092F },
    { 0x212B, 0x0041, 0x030A },
    { 0x219A, 0x2190, 0x0338 },
    { 0x219B, 0x2192, 0x0338 },
    { 0x21AE, 0x2194, 0x0338 },
    { 0x21CD, 0x21D0, 0x0338 },
    { 0x21CE, 0x21D4, 0x0338 },
    { 0x21CF, 0x21D2, 0x0338 },
    { 0x2204, 0x2203, 0x0338 },
    { 0x304C, 0x304B, 0x3099 },
    { 0x304E, 0x304D, 0x3099 },
    { 0x3050, 0x304F, 0x3099 },
    { 0x3052, 0x3051, 0x3099 },
    { 0x3054, 0x3053, 0x3099 },
    { 0x3056, 0x3055, 0x3099 },
    { 0x3058, 0x3057, 0x3099 },
    { 0x305A, 0x3059, 0x3099 },
    { 0x305C, 0x305B, 0x3099 },
    { 0x305E, 0x305D, 0x3099 },
    { 0x3060, 0x305F, 0x3099 },
    { 0x3062, 0x3061, 0x3099 },
    { 0x3065, 0x3064, 0x3099 },
    { 0x3067, 0x3066, 0x3099 },
    { 0x3069, 0x3068, 0x3099 },
    { 0x3070, 0x306F, 0x3099 },
    { 0x3071, 0x306F, 0x309A },
    { 0x3073, 0x3072, 0x3099 },
    { 0x3074, 0x3072, 0x309A },
    { 0x3076, 0x3075, 0x3099 },
    { 0x3077, 0x3075, 0x309A },
    { 0x3079, 0x3078, 0x3099 },
    { 0x307A, 0x3078, 0x309A },
    { 0x307C, 0x307B, 0x3099 },
    { 0x307D, 0x307B, 0x309A },
    { 0x3094, 0x3046, 0x3099 },
    { 0x309E, 0x309D, 0x3099 },
    { 0x30AC, 0x30AB, 0x3099 },
    { 0x30AE, 0x30AD, 0x3099 },
    { 0x30B0, 0x30AF, 0x3099 },
    { 0x30B2, 0x30B1, 0x3099 },
    { 0x30B4, 0x30B3, 0x3099 },
    { 0x30B6, 0x30B5, 0x3099 },
    { 0x30B8, 0x30B7, 0x3099 },
    { 0x30BA, 0x30B9, 0x3099 },
    { 0x30BC, 0x30BB, 0x3099 },
    { 0x30BE, 0x30BD, 0x3099 },
    { 0x30C0, 0x30BF, 0x3099 },
    { 0x30C2, 0x30C1, 0x3099 },
    { 0x30C5, 0x30C4, 0x3099 },
    { 0x30C7, 0x30C6, 0x3099 },
    { 0x30C9, 0x30C8, 0x3099 },
    { 0x30D0, 0x30CF, 0x3099 },
    { 0x30D1, 0x30CF, 0x309A },
    { 0x30D3, 0x30D2, 0x3099 },
    { 0x30D4, 0x30D2, 0x309A },
    { 0x30D6, 0x30D5, 0x3099 },
    { 0x30D7, 0x30D5, 0x309A },
    { 0x30D9, 0x30D8, 0x3099 },
    { 0x30DA, 0x30D8, 0x309A },
    { 0x30DC, 0x30DB, 0x3099 },
    { 0x30DD, 0x30DB, 0x309A },
    { 0x30F4, 0x30A6, 0x3099 },
    { 0x30F7, 0x30EF, 0x3099 },
    { 0x30F8, 0x30F0, 0x3099 },
    { 0x30F9, 0x30F1, 0x3099 },
    { 0x30FA, 0x30F2, 0x3099 },
    { 0x30FE, 0x30FD, 0x3099 }
};




} // namespace Text

} // namespace EA









